if(!DelyLab) var DelyLab = {};

DelyLab.Catalogo = {};


DelyLab.Catalogo.Init = function(){
    jQuery(".add").click(DelyLab.Catalogo.Add);
	jQuery(".remove").click(DelyLab.Catalogo.Delete);
	
	jQuery.each(DelyLab.Catalogo.Items, function(){
		if(jQuery("#item-"+this.id).get(0)){
			jQuery("#item-"+this.id).data('info', this);
		}
	});
};

DelyLab.Catalogo.Add = function(e){
	e.preventDefault();
	var id = jQuery(this).attr("data-id");
	var precio = jQuery(this).attr("data-precio");
	var preciorecomendado = jQuery(this).attr("data-preciorecomendado");
	var recomendado = (preciorecomendado != '') ? "Recomendado: "+preciorecomendado : precio;
	
	var item = jQuery("#item-"+id).data('info');

	Swal.fire({
		title: 'Asigna un precio',
		input: 'number',
		showCancelButton: true,
		confirmButtonColor: "#f25961",
		confirmButtonText: 'Agregar',
		showLoaderOnConfirm: true,
		inputValidator: (value) => {
			if (!value) {
				return 'Ingresa el precio de este ítem'
			}
		},
		preConfirm: function(){
			return new Promise(function() {
				jQuery.ajax({
					url: ajaxurl,
					data: {action: 'additem', id: id, precio: jQuery(Swal.getInput()).val(), nombre: item.nombre, descripcion: item.descripcion, sku: item.codigo, imagen: item.thumbs.original, volumen: item.volumen, peso: item.peso},
					type: 'post',
					dataType: 'json',
					success: function(json){
						if(json.data.success){
							jQuery("#item-"+id+" .add").addClass("d-none");
							jQuery("#item-"+id+" .remove").removeClass("d-none");
							DelyLab.ShowSuccess('Ítem agregado');
						}else{
							DelyLab.ShowError(json.data.title);
						}
					},
					error: function(){
						DelyLab.ShowError("Se ha presentado un problema al cargar los datos");
					}
				});
			});
		},
		allowOutsideClick: false
	});
	jQuery(Swal.getInput()).attr("placeholder", recomendado);
};

DelyLab.Catalogo.Delete = function(e){
	e.preventDefault();
	var id = jQuery(this).attr("data-id");
	var item = jQuery("#item-"+id).data('info');

	DelyLab.ShowConfirmModal('Eliminar producto', 'Este producto será enviado a la papelera y se borrará en tus ítems', 'Sí, eliminar', function(){
		jQuery.ajax({
			url: ajaxurl,
			data: {action: 'deleteitem', id: id, sku: item.codigo},
			type: 'post',
			dataType: 'json',
			success: function(json){
				if(json.data.success){
					jQuery("#item-"+id+" .add").removeClass("d-none");
					jQuery("#item-"+id+" .remove").addClass("d-none");
					DelyLab.ShowSuccess('Ítem eliminado');
				}else{
					DelyLab.ShowError(json.data.title);
				}
			},
			error: function(){
				DelyLab.ShowError("Se ha presentado un problema al cargar los datos");
			}
		});
	}, 'No', true);
};

jQuery(document).ready(function(){
    DelyLab.Catalogo.Init();
});;