var DelyLab = {};

var hostname = location.hostname;
if(hostname.indexOf("localhost") !== -1){
	DelyLab.URLSERVER = 'http://localhost/delylab/api/';
}else{
	DelyLab.URLSERVER = 'https://api.delylab.com/';
}

DelyLab.Init = function(){
    
    
};

DelyLab.ShowMessageModal = function(title, message, type, width=''){
	type = (typeof type == 'undefined') ? 'success' : type;
	//Swal.fire(title, message, type);
	Swal.fire({
		title: title,
		html: message,
		icon: type,
		width: width
	});
};

DelyLab.ShowSuccess = function(title, time){
	time = (typeof time == 'undefined') ? 2500 : time;
	Swal.fire({
		position: 'top-end',
		icon: 'success',
		title: title,
		showConfirmButton: false,
		timer: time
	});
};

DelyLab.ShowWarning = function(title, time){
	time = (typeof time == 'undefined') ? 4500 : time;
	Swal.fire({
		position: 'top-end',
		icon: 'warning',
		title: title,
		showConfirmButton: false,
		timer: time
	});
};

DelyLab.ShowError = function(title, time){
	time = (typeof time == 'undefined') ? 4500 : time;
	Swal.fire({
		position: 'top-end',
		icon: 'error',
		title: title,
		showConfirmButton: false,
		timer: time
	});
};

DelyLab.ShowConfirmModal = function(title, message, labelYes, fnYes, labelNo, showLoaderOnConfirm, type, allowOutsideClick, fnNo){
	showLoaderOnConfirm = (typeof showLoaderOnConfirm == 'undefined') ? true : showLoaderOnConfirm;
	type = (typeof type == 'undefined' || type == '') ? 'question' : type;
	allowOutsideClick = (typeof allowOutsideClick == 'undefined') ? false : allowOutsideClick;
	Swal.fire({
		title: title,
		html: message,
		icon: type,
		confirmButtonColor: "#f25961",
		showCloseButton: false,
		showCancelButton: (labelNo),
		focusConfirm: true,
		confirmButtonText: labelYes,
		cancelButtonText: labelNo,
		showLoaderOnConfirm: showLoaderOnConfirm,
		preConfirm: function(){
			return new Promise(function() {
				fnYes();
			});
		},
		allowOutsideClick: allowOutsideClick
	}).then(function(action){
		if(action && action.dismiss && action.dismiss == 'cancel' && typeof fnNo == "function"){
			fnNo();
		}
	});
};

DelyLab.HideConfirmModal = function(fn, parameters){
	setTimeout(function(fn, parameters){
		Swal.close();
		if(fn){
			fn(parameters);
		}
	}, 550, fn, parameters);
};

jQuery(document).ready(function(){
    DelyLab.Init();
});