<?php
/**
* @package DelyLabPlugin
*/
/*
Plugin Name: DelyLab Plugin
Plugin URI: http://delylab.com/api
Description: Plugin DelyLab para crear automáticamente pedidos en el sistema al hacer una compra mediante WooCommerce.
Version: 1.7.0
Author: DelyLab
Author URI: http://delylab.com
License: GPL2 or later
Text Domain: delyLab-plugin
*/

$__versionDelyLab__ = '1.7.1';

/*if(!defined('ABSPATH')){
	die('Hey! No deberías estar aquí dentro');
}

if(!function_exists('add_action')){
	die('Hey! No deberías estar aquí dentro');
}*/

/*if(!isset($_POST["delylab-api"]) && (!function_exists('add_action') || !defined('ABSPATH'))){
	die('Hey! No deberías estar aquí dentro');
}*/

class DelyLabPlugin{
	
	private $tableName = '';
	private $charsetCollate;
	private $dirData = '';
	private $dirHtml = '';
	private $fileData = '';
	private $version = '';
	private $url;
	private $authKey = AUTH_KEY;
	
	private $data = array();
	
	function __construct(){

		global $wpdb, $__versionDelyLab__;
		
		$this->version = $__versionDelyLab__;
		
		if(stripos($_SERVER['SERVER_NAME'], 'localhost') !== false){
			$this->url = 'http://localhost/delylab/api/';
			//$this->url = 'https://api.delylab.com/';
		}else{
			$this->url = 'https://api.delylab.com/';
		}
		
		/*$this->charsetCollate = $wpdb->get_charset_collate();
   		$this->tableName = $wpdb->prefix . "delylab";*/
		
		/*$this->dirDelivery = ABSPATH."wp-content/plugins/delylab-plugin/delivery/";
		if(!file_exists($this->dirDelivery)) mkdir($this->dirDelivery);
		$_nameFileDelivery = "data_".date("ymd").".txt";
		$this->fileDelivery = $this->dirDelivery.$_nameFileDelivery;
		
		$this->dirHtml = ABSPATH."wp-content/plugins/delylab-plugin/html/";*/
		
		$_data = array(
			'auth_key'	=>	$this->authKey
		);
		$_result = $this->Run('wordpress/getdata', $_data);
		
		if($_result && isset($_result->success) && $_result->success){
			$this->SetData($_result);
		}
		
		// borrar los archivos de la carpeta delivery que no sean fileDelivery
		/*$_filesDelivery = scandir($this->dirDelivery);
		foreach($_filesDelivery as $_f){
			if(strlen($_f) > 2 && $_f != $_nameFileDelivery){
				unlink($this->dirDelivery.$_f);
			}
		}*/
	}
	
	private function Run($pUrl, $pData=array()){
		$_url = $this->url.$pUrl;
		if(!isset($pData["key"])){
			$pData["key"] = (isset($this->data->token)) ? $this->data->token : '';
		}
		
		$_result = wp_remote_post($_url, array(
			'body'	=>	$pData
		));
		if ( ! is_wp_error( $_result ) && 200 === wp_remote_retrieve_response_code( $_result ) ) {
			if(isset($_result["body"]) && $_result["body"] !== false && $_result["body"] != ''){
				$_result = json_decode($_result["body"]);
				if(isset($_result->output)){
					return $_result->output;
				}else{
					return (object)array(
						'success'	=> false
					);
				}
			}else{
				return (object)array(
					'success'	=> false
				);
			}
		}else{
			return (object)array(
				'success'	=> false
			);
		}
	}
	
	/*private function Run($pUrl, $pData=array()){
		$_url = $this->url.$pUrl;
		if(!isset($pData["key"])){
			$pData["key"] = $this->data->token;
		}
		
		$_options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($pData)
			)
		);
		$_context  = stream_context_create($_options);
		$_result = file_get_contents($_url, false, $_context);

		if($_result !== false){
			$_result = json_decode($_result);
			if(isset($_result->output)){
				return $_result->output;
			}
			return $_result;
		}else{
			return array();
		}
	}*/
	
	public function Activate(){
		
	}
	
	public function Desactivate(){
		
	}
	
	public function Uninstall(){
		
	}
	
	public function SetData($pResult){
		$_result = $pResult;
		
		if(isset($_result->data)){
			$this->data = $_result->data;
		}else{
			$this->data = (object)array(
				'token'		=>	'',
				'dias'		=>	'',
				'tienda'	=>	''
			);
		}
	}
	
	public function GetToken(){
		return $this->data->token;
	}
	
	public function SetDataToken($pToken, $pDias){
		$_url = $this->url.'wordpress/settoken';
		
		$_urlWordpress = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https://": "http://";
		$_urlWordpress .=$_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
		
		$_data = array(
			'auth_key'	=>	$this->authKey,
			'url'		=>	$_urlWordpress,
			'abspath'	=>	ABSPATH,
			'token'		=>	$pToken,
			'dias'		=>	$pDias
		);
		
		$_result = $this->Run('wordpress/settoken', $_data);

		if($_result->success){
			$this->SetData($_result);
		}
	}
	
	public function SetDataTienda($pTienda){
		
		$_urlWordpress = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https://": "http://";
		$_urlWordpress .=$_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
		
		$_data = array(
			'auth_key'	=>	$this->authKey,
			'url'		=>	$_urlWordpress,
			'abspath'	=>	ABSPATH,
			'tienda'	=>	$pTienda
		);

		$_result = $this->Run('wordpress/settienda', $_data);

		if($_result->success){
			$this->SetData($_result);
		}
	}
	
	/*public function AddDelivery($pIdDelivery){
		$_data = $this->Leer($this->fileDelivery);
		if($_data != ''){
			$_data = json_decode($_data, true);
		}else{
			$_data = array();
		}
		$_data[] = $pIdDelivery;
		$this->Archivo(json_encode($_data), $this->fileDelivery);
	}*/
	
	public function GetDias(){
		return $this->data->dias;
	}
	
	public function GetTienda(){
		return $this->data->tienda;
	}
	
	public function DeliveryExists($pIdDelivery){
		$_data = $this->Leer($this->fileDelivery);
		$_exists = false;
		if($_data != ''){
			$_data = json_decode($_data, true);
			foreach($_data as $_d){
				if($_d == $pIdDelivery){
					$_exists = true;
				}
			}
		}
		return $_exists;
	}
	
	public function AddPageToMenu(){
		$_ico = "data:image/svg+xml;base64,".base64_encode(file_get_contents(realpath(dirname(__FILE__)).'/images/D.svg'));
		add_menu_page( 'DelyLab Plugin', 'DelyLab', 'manage_options', 'delylab-plugin', array($this, 'HtmlPageMenu'), $_ico, 68 );
	}
	
	public function HtmlPageMenu(){
		$_saved = false;
		$_newVersion = ($this->LastVersion() != $this->version);
		if (!empty($_POST)) {
			$_tabForm = (isset($_POST["tab"])) ? $_POST["tab"] : '';
			
			if($_tabForm == 'token'){
				$this->SetDataToken($_POST["token-delylab"], $_POST["dias-delylab"]);
				$_saved = true;
			}else if($_tabForm == 'store'){
				$this->SetDataTienda($_POST["tienda-delylab"]);
				$_saved = true;
			}
		}
		
		$_token = $this->GetToken();
		$_token = explode("-", $_token);
		if(is_numeric($_token[0])){ // ES CLIENTE
			$_isCatalogue = $this->Run('company/iscatalogue');
			$_tabCatalogue = ((isset($_isCatalogue->isCatalogue)) && $_isCatalogue->isCatalogue);
		}else{
			$_tabCatalogue = false;
		}
		
		
		$_tab = (isset($_GET['tab']) && $_GET['tab'] != '') ? $_GET['tab'] : 'token';
		$_notoken = (!$this->CheckToken());
		if($_tab == 'token'){
			$__token__ = $this->GetToken();
			$_notoken = ($__token__ == '') ? false : $_notoken;
			$__dias__ = $this->GetDias();
		}else if($_tab == 'store'){
			$__tiendas__ = $this->GetStores();
			$_myStore = $this->GetTienda();
		}else if($_tab == 'catalogue'){
			$_output = $this->Run("items/getall");
			
			$_allItems = ($_output->success) ? $_output->items : array();
			$_currency = ($_output->success) ? $_output->currency : '';
			
			$_products = wc_get_products(
				array(
					'post_type'	=> 'product',
					'nopaging'	=> true
				)
			);

			$_items = array();
			for($_i=0;$_i<count($_allItems);$_i++){
				$_iE = $_allItems[$_i];
				if($_iE->codigo != ''){
					$_items[$_i] = $_iE;
					foreach($_products as $_product){
						if($_iE->codigo == $_product->get_sku()){
							$_items[$_i]->exists = true;
						}
					}
					$_items[$_i]->exists = (isset($_items[$_i]->exists)) ? $_items[$_i]->exists : false;
					$_items[$_i]->currency = $_currency;
				}
			}
			
			//$this->Imprimir($_items, 1);
		}
		include_once("form.php");
	}
	
	public function LastVersion(){
		
		$_result = $this->Run('wordpress/version');
		if($_result->success){
			return $_result->version;
		}
		return '';
	}
	
	public function GetStore(){
		
		$_key = $this->GetToken();
		
		$_url = $this->url.'store';
		$_myStore = $this->GetTienda();
		$_data = array(
			'key'	=>	$_key,
			'id'	=>	$_myStore
		);
		$_result = $this->Run('store', $_data);
		if(isset($_result->store)){
			$_store = json_decode(json_encode($_result->store), true);
			return $_store;
		}
		return array();
	}
	
	public function GetStores(){
		
		$_key = $this->GetToken();
		
		$_url = $this->url.'stores';
		$_data = array(
			'key'	=>	$_key
		);
		$_result = $this->Run('stores', $_data);
		if(isset($_result->stores)){

			$_stores = json_decode(json_encode($_result->stores), true);
			return $_stores;
		}
		return array();
	}
	
	public function CheckToken(){
		
		$_key = $this->GetToken();
		$_data = array(
			'key'	=>	$_key
		);
		$_result = $this->Run('check-key', $_data);
		return ($_result->success);
	}
	
	public function PaymentComplete($pOrderId){
		
		// SI YA EXISTE ESTE CÓDIGO NO VOLVER A INGRESARLO
		/*if($this->DeliveryExists($pOrderId)){
			return false;
		}*/
		
		$_order = new WC_Order($pOrderId);
		
		if($_order->has_shipping_method('local_pickup')){ // NO SE CREA PORQUE LO VAN A RECOGER
			return false;
		}
	
		$_key = $this->GetToken();
		
		$_diasDelivery = $this->GetDias();
		$_fechaDelivery = wp_date("Y-m-d", time()+(24*60*60*$_diasDelivery));
		
		$_products = $_order->get_items();
		$_items = array();
		foreach ($_products as $_itemId => $_item ) {
			// Get an instance of corresponding the WC_Product object
			$_product = $_item->get_product();
			
			$_nombre = $_product->get_name();
			$_codigo = $_product->get_sku();
			$_cantidad = $_item->get_quantity();
			$_precio = $_product->get_regular_price();
			$_image = wp_get_attachment_url($_product->get_image_id());

			$_items[] = array(
				'name'				=>	$_nombre,
				'sku'				=>	$_codigo,
				'quantity'			=>	$_cantidad,
				'unit_price'		=>	$_item['total']/$_item['quantity'],
				'unit_real_price'	=>	$_precio,
				'image'				=>	$_image
			);
		}

		$_deliveryLatitudeBilling = $_deliveryLongitudeBilling = $_deliveryLatitudeShipping = $_deliveryLongitudeShipping = $_deliveryDistance = '';
		
		foreach($_order->get_data()["meta_data"] as $_data){
			if($_data->key == '_billing_latitude'){
				$_deliveryLatitudeBilling = $_data->value;
			}
			if($_data->key == '_billing_longitude'){
				$_deliveryLongitudeBilling = $_data->value;
			}
			if($_data->key == '_shipping_latitude'){
				$_deliveryLatitudeShipping = $_data->value;
			}
			if($_data->key == '_shipping_longitude'){
				$_deliveryLongitudeShipping = $_data->value;
			}
			if($_data->key == '_billing_calculate_distance'){
				$_deliveryDistance = $_data->value;
			}
		}
        
        //$this->Imprimir($_order, 1);
        
		$_latitude = ($_deliveryLatitudeShipping != '') ? $_deliveryLatitudeShipping : $_deliveryLatitudeBilling;
		$_longitude = ($_deliveryLongitudeShipping != '') ? $_deliveryLongitudeShipping : $_deliveryLongitudeBilling;
		
		$_deliveryDatoExtra = $_order->get_customer_note();
		
		$_clienteNombre = ($_order->get_shipping_first_name() != '') ? $_order->get_shipping_first_name() : $_order->get_billing_first_name();
		$_clienteApellido = ($_order->get_shipping_last_name() != '') ? $_order->get_shipping_last_name() : $_order->get_billing_last_name();
		$_clienteEmail = $_order->get_billing_email();
		$_clienteCelular = $_order->get_billing_phone();
		$_clienteEmpresa = ($_order->get_shipping_company() != '') ? $_order->get_shipping_company() : $_order->get_billing_company();

		$_pais = ($_order->get_shipping_country() != '') ? $_order->get_shipping_country() : $_order->get_billing_country();

		$_deliveryDireccion1 = ($_order->get_shipping_address_1() != '') ? $_order->get_shipping_address_1() : $_order->get_billing_address_1();
		$_deliveryDireccion2 = ($_order->get_shipping_address_2() != '') ? $_order->get_shipping_address_2() : $_order->get_billing_address_2();
		$_deliveryCiudad = (trim($_order->get_shipping_city()) != '') ? trim($_order->get_shipping_city()) : trim($_order->get_billing_city());

		$_deliveryTotal = $_order->get_total();
        $_deliveryAdditionalCharge = $_order->get_subtotal();
        
        //$_deliveryPrecio = $_order->get_shipping_total();
        $_deliveryPrecio = $_deliveryTotal-$_deliveryAdditionalCharge;
		$_deliveryPago = ($_order->get_date_paid() != '' || is_object($_order->get_date_paid())) ? 1 : 0;
		
		$_store = $this->GetTienda();

		$_data = array(
			'key'						=>	$_key,
            'ordernumber'               =>	$pOrderId,
			'country'					=>	$_pais,
			'date_delivery'				=>	$_fechaDelivery,
			'name_client'				=>	$_clienteNombre,
			'lastname_client'			=>	$_clienteApellido,
			'email_client'				=>	$_clienteEmail,
			'phone_client'				=>	$_clienteCelular,
			'company_client'			=>	$_clienteEmpresa,
			'latitude_delivery'			=>	$_latitude,
			'longitude_delivery'		=>	$_longitude,
			'address1_delivery'			=>	$_deliveryDireccion1,
			'address2_delivery'			=>	$_deliveryDireccion2,
			'city_delivery'				=>	$_deliveryCiudad,
			'distance_delivery'			=>	$_deliveryDistance,
			'price_delivery'			=>	$_deliveryPrecio,
			'additional_charge'			=>	$_deliveryAdditionalCharge,
            'price_total'				=>	$_deliveryTotal,
			'paid_delivery'				=>	$_deliveryPago,
			'items'						=>	json_encode($_items),
			'store'						=>	$_store,
			'description1_delivery'		=>	'Creado desde web. Nro de pedido #'.$pOrderId,
			'description2_delivery'		=>	$_deliveryDatoExtra
		);
		
		$this->Run('delivery/add', $_data);
	}
	
	public function AddLatLng($pFields){
		$_fields = $pFields;

		$_fields['billing']['billing_calculate_distance']['required'] = false;
		$_fields['billing']['billing_calculate_distance']['type'] = 'hidden';
		
		$_fields['billing']['billing_latitude']['required'] = false;
		$_fields['billing']['billing_latitude']['type'] = 'hidden';
		$_fields['billing']['billing_latitude']['autocomplete'] = 'billing_latitude';
		$_fields['billing']['billing_latitude']['default'] = WC()->session->get('billing_latitude');
		
		$_fields['billing']['billing_longitude']['required'] = false;
		$_fields['billing']['billing_longitude']['type'] = 'hidden';
		$_fields['billing']['billing_longitude']['autocomplete'] = 'billing_longitude';
		$_fields['billing']['billing_longitude']['default'] = WC()->session->get('billing_longitude');
		
		$_fields['shipping']['shipping_latitude']['required'] = false;
		$_fields['shipping']['shipping_latitude']['type'] = 'hidden';
		$_fields['shipping']['shipping_latitude']['autocomplete'] = 'shipping_latitude';
		$_fields['shipping']['shipping_latitude']['default'] = WC()->session->get('shipping_latitude');
		
		$_fields['shipping']['shipping_longitude']['required'] = false;
		$_fields['shipping']['shipping_longitude']['type'] = 'hidden';
		$_fields['shipping']['shipping_longitude']['autocomplete'] = 'shipping_longitude';
		$_fields['shipping']['shipping_longitude']['default'] = WC()->session->get('shipping_longitude');
		
		return $_fields;
	}
	
	public function AddMap() {
		$_store = $this->GetStore();
		$_recojoLatitude = (isset($_store["latitud"])) ? $_store["latitud"] : '';
		$_recojoLongitude = (isset($_store["longitud"])) ? $_store["longitud"] : '';
		
		$_html = '<script>
			var DelyLabRecojoLatitude = '.$_recojoLatitude.';
			var DelyLabRecojoLongitude = '.$_recojoLongitude.';
		</script>';
		
		$_html .= $this->Leer($this->dirHtml."checkout_mapa.html");
		echo $_html;
	}
	
	public function SetFieldsValue($post_data){
		$post_arr = array();
		parse_str($post_data, $post_arr);
		wc_clean($post_arr);
		if(isset($post_arr['billing_latitude'])) {
			WC()->session->set('billing_latitude', $post_arr['billing_latitude']);
		}
		if(isset($post_arr['billing_longitude'])) {
			WC()->session->set('billing_longitude', $post_arr['billing_longitude']);
		}
		if(isset($post_arr['shipping_latitude'])) {
			WC()->session->set('shipping_latitude', $post_arr['shipping_latitude']);
		}
		if(isset($post_arr['shipping_longitude'])) {
			WC()->session->set('shipping_longitude', $post_arr['shipping_longitude']);
		}
	}
	
	public function ChangeCity($pFields){
		$_key = $this->GetToken();
		
		$_url = $this->url.'locations';
		$_data = array(
			'key'	=>	$_key
		);
		$_result = $this->Run('locations', $_data);
		if($_result->success && isset($_result->locations)){
			
			$_locations = $_result->locations;
			$_ciudades = array();
			foreach($_locations as $_l){
				$_ciudadesId[] = (isset($_l->name)) ? $_l->name : $_l->nombre;
				$_ciudadesNombre[] = (isset($_l->name)) ? $_l->name : $_l->nombre;
			}
			$_ciudadesId[] = "NULL";
			$_ciudadesNombre[] = "Otro";
			$pFields['billing']['billing_city'] = array(
				'type' => 'select',
				'options' => array_combine( $_ciudadesId, $_ciudadesNombre ),
				'label' => 'Ciudad',
				'required' => true,
				'class' => array( 'form-row-wide' ),
				'clear' => true
			);
			
			$pFields['shipping']['shipping_city'] = array(
				'type' => 'select',
				'options' => array_combine( $_ciudadesId, $_ciudadesNombre ),
				'label' => 'Ciudad',
				'required' => true,
				'class' => array( 'form-row-wide' ),
				'clear' => true
			);
		}
		
		return $pFields;
	}
	
	public function IncludeCssAndJs() {
		
		wp_enqueue_style('bootstrap-css', plugins_url( 'css/bootstrap.min.css', __FILE__ ), array(), '4.0.0');
		wp_enqueue_script('bootstrap-js', plugins_url( 'js/bootstrap.min.js', __FILE__ ), array( 'jquery' ), '4.0.0', false);
		
	}
	
	public function AddItemApi(){
		try{
			
			$_PG = $_REQUEST;
			$_id = (isset($_PG["id"])) ? $_PG["id"] : '';
			$_precio = (isset($_PG["precio"])) ? $_PG["precio"] : '';
			$_data = array(
				'id'		=>	$_id,
				'precio'	=>	$_precio,
				'wordpress'	=>	1
			);

			$_result = $this->Run("items/add-parent", $_data);
		} catch (Exception $e) {
		}
		
		$_output = array(
			'success'	=>	true
		);
		return wp_send_json_success($_output);
	}
	
	public function SaveBase64Image($pBase64Image) {
		$_uploadDir = wp_upload_dir();
		$_imageData = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $pBase64Image));
		$_imageInfo = getimagesizefromstring($_imageData);
		$_imageType = $_imageInfo[2];
		$_extension = image_type_to_extension($_imageType, false);
		$_file = $_uploadDir['path'] . '/' . uniqid() . '.' . $_extension;

		$pBase64Image = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $pBase64Image));
		if (file_put_contents($_file, $pBase64Image)){
			return $_uploadDir['url'] . '/' . basename($_file);
		}

		return false;
	}
	
	public function ReplaceBase64Images($pProductDescription) {
		$_pattern = '/<img([^>]+)src="([^"]+)"([^>]*)>/';
		$pProductDescription = preg_replace_callback($_pattern, function ($_matches) {
			$_attributesBefore = $_matches[1]; // Atributos antes de src
			$_imageData = $_matches[2]; // Datos de la imagen en base64
			$_attributesAfter = $_matches[3]; // Atributos después de src
			
			if(strpos($_imageData, "data:") !== false){
				// Guarda la imagen como archivo y obtén la URL del archivo guardado
				$_imagePath = $this->SaveBase64Image($_imageData);
				
				if ($_imagePath) {
					// Reconstruye la etiqueta <img> con la URL de la imagen y conserva todos los atributos
					$_imgTag = '<img' . $_attributesBefore . 'src="' . $_imagePath . '"' . $_attributesAfter . '>';
					return $_imgTag;
				}
				
			}
			return $_matches[0]; // Si no se pudo guardar la imagen, devuelve el valor original
		}, $pProductDescription);

		return $pProductDescription;
	}
	
	public function AddItem(){
		$_PG = $_REQUEST;
		
		$_precio = (isset($_PG["precio"])) ? $_PG["precio"] : '';
		$_nombre = (isset($_PG["nombre"])) ? $_PG["nombre"] : '';
		$_descripcion = (isset($_PG["descripcion"])) ? stripslashes($_PG["descripcion"]) : '';
		$_sku = (isset($_PG["sku"])) ? $_PG["sku"] : '';
		$_volumen = (isset($_PG["volumen"])) ? $_PG["volumen"] : '';
		$_peso = (isset($_PG["peso"])) ? $_PG["peso"] : '';
		$_imagen = (isset($_PG["imagen"])) ? $_PG["imagen"] : '';
		
		if(is_numeric($_precio) && $_nombre != '' && $_sku != ''){
			$_descripcion = $this->ReplaceBase64Images($_descripcion);
			$_product = new WC_Product_Simple();
			$_product->set_name($_nombre);
			$_product->set_description($_descripcion);
			$_product->set_sku($_sku);
			$_product->set_regular_price($_precio);
			if($_peso != '' && $_peso != 0){
				$_product->set_weight($_peso/1000);
			}
			if($_volumen != '' && $_volumen != 0){
				$_product->set_length($_volumen/3);
				$_product->set_width($_volumen/3);
				$_product->set_height($_volumen/3);
			}

			$_product->save();
			
			$_uploadDir = wp_upload_dir();
			$_imageData = file_get_contents($_imagen);
			$_filename = basename($_imagen);
			if(wp_mkdir_p($_uploadDir['path'])){
				$_file = $_uploadDir['path'] . '/' . $_filename;
			}else{
				$_file = $_uploadDir['basedir'] . '/' . $_filename;
			}
			file_put_contents($_file, $_imageData);

			$_wpFiletype = wp_check_filetype($_filename, null );
			$_attachment = array(
				'post_mime_type' => $_wpFiletype['type'],
				'post_title' => sanitize_file_name($_filename),
				'post_content' => '',
				'post_status' => 'inherit'
			);
			$_attachId = wp_insert_attachment( $_attachment, $_file, $_product->get_id() );
			require_once(ABSPATH . 'wp-admin/includes/image.php');
			$_attachData = wp_generate_attachment_metadata( $_attachId, $_file );
			$_res1 = wp_update_attachment_metadata( $_attachId, $_attachData );
			$_res2 = set_post_thumbnail($_product->get_id(), $_attachId );

			$_output = array(
				'success'	=>	true
			);
		}else{
			$_output = array(
				'success'	=>	false,
				'title'		=> 'Datos faltantes. Revisa o vuelve a refrescar'
			);
		}
		
		
		return $_output;
	}
	
	public function DeleteItemApi(){
		$_PG = $_REQUEST;
		
		$_id = (isset($_PG["id"])) ? $_PG["id"] : '';
		$_sku = (isset($_PG["sku"])) ? $_PG["sku"] : '';
		
		if($_sku != ''){
			
			$_data = array(
				'id'		=>	$_id,
				'wordpress'	=>	'1'
			);
			
			$this->Run("items/delete-parent", $_data);
			
			$_output = array(
				'success'	=>	true
			);
		}else{
			$_output = array(
				'success'	=>	false,
				'title'		=> 'Datos faltantes. Revisa o vuelve a refrescar'
			);
		}
		
		
		return wp_send_json_success($_output);
	}
	
	public function DeleteItem(){
		$_PG = $_REQUEST;
		
		$_sku = (isset($_PG["sku"])) ? $_PG["sku"] : '';
		
		if($_sku != ''){
			$_productId = wc_get_product_id_by_sku( $_sku );
			wp_delete_post($_productId, true );
			
			$_output = array(
				'success'	=>	true
			);
		}else{
			$_output = array(
				'success'	=>	false,
				'title'		=> 'Datos faltantes. Revisa o vuelve a refrescar'
			);
		}
		
		
		return $_output;
	}
	
	public function Imprimir($str, $exit=false){
		echo '<pre>';
		print_r($str);
		echo '</pre>';
		if($exit) exit();
	}
	
	public function Archivo($pStr, $pFile='debug'){
		$pFile .= ".txt";
		$g = fopen($pFile, "w");
		fwrite($g, $pStr);
		fclose($g);
	}
	
	public function Leer($pFile){
		$_str = '';
		if(file_exists($pFile)){
			$_str = file_get_contents($pFile);
		}
		return $_str;
	}
}



if(!defined('AUTH_KEY') && isset($_POST["AUTH_KEY"])){
	define('AUTH_KEY', $_POST["AUTH_KEY"]);	
}

if(!defined('ABSPATH') && isset($_POST["ABSPATH"])){
	define('ABSPATH', $_POST["ABSPATH"]);
	require_once(ABSPATH."wp-load.php");
}

$DelyLabPlugin = new DelyLabPlugin();

if(isset($_POST["delylab-api"])){
	try{
		switch($_POST["delylab-api"]){
		
			case 'additem':
				$DelyLabPlugin->AddItem();
				break;

			case 'deleteitem':
				$DelyLabPlugin->DeleteItem();
				break;

		}
	} catch (Exception $e) {
	}
}

add_action('admin_menu',  array($DelyLabPlugin, 'AddPageToMenu'));

//add_action( 'woocommerce_thankyou', 'PaymentComplete');
add_action( 'woocommerce_thankyou', array($DelyLabPlugin, 'PaymentComplete'));

// CAMBIAR LAS CIUDADES
add_filter( 'woocommerce_checkout_fields', array($DelyLabPlugin, 'ChangeCity'), 10, 1 );

add_action( 'admin_enqueue_scripts', array($DelyLabPlugin, 'IncludeCssAndJs'));

add_action( 'wp_ajax_additem', array($DelyLabPlugin, 'AddItemApi') );
add_action( "wp_ajax_nopriv_additem", array($DelyLabPlugin, 'AddItemApi') );

add_action( 'wp_ajax_deleteitem', array($DelyLabPlugin, 'DeleteItemApi') );
add_action( "wp_ajax_nopriv_deleteitem", array($DelyLabPlugin, 'DeleteItemApi') );

// AGREGAR CAMPOS DE LATITUD, LONGITUD y DISTANCIA
//add_filter( 'woocommerce_checkout_fields', array($DelyLabPlugin, 'AddLatLng'));

// agregar mapa
//add_action('woocommerce_after_checkout_form', array($DelyLabPlugin, 'AddMap'));

// RECUPERAR VALORES DE LOS CAMPOS
//add_action('woocommerce_checkout_update_order_review', array($DelyLabPlugin, 'SetFieldsValue'));


// activation

register_activation_hook(__FILE__, array($DelyLabPlugin, 'Activate'));

// desactivation

//register_deactivation_hook(__FILE__, array($DelyLabPlugin, 'Desactivate'));

// uninstall

//register_uninstall_hook(__FILE__, array($DelyLabPlugin, 'Uninstall'));
